/* Basic routine to solve the endian problems */

#include <stdlib.h>

#define BINARY_C
#include "binary.h"

int read_le_int16(FILE *in, short *out)
{
	int i, work;

	short r = 0;
	
	for(i=0;i<2;i++){
		if((work = fgetc(in)) != EOF){
			r += (work & 0xFF) << (i*8);
		}else{
			*out = 0;
			return 0;
		}
	}
	
	*out = r;
	return 1;
}

int read_le_int32(FILE *in, int *out)
{
	int i, work;

	int r = 0;
	
	for(i=0;i<4;i++){
		if((work = fgetc(in)) != EOF){
			r += (work & 0xFF) << (i*8);
		}else{
			*out = 0;
			return 0;
		}
	}
	
	*out = r;
	return 1;
}

int write_le_int16(short in, FILE *out)
{
	int i;
	
	for(i=0;i<2;i++){
		if((fputc((in >> (i*8)) & 0xFF, out)) == EOF){
			return 0;
		}
	}

	return 1;
}

int write_le_int32(int in, FILE *out)
{
	int i;
	
	for(i=0;i<4;i++){
		if((fputc( (in >> (i*8)) & 0xFF, out)) == EOF){
			return 0;
		}
	}

	return 1;
}

int read_be_int16(FILE *in, short *out)
{
	int i, work;

	short r = 0;
	
	for(i=0;i<2;i++){
		if((work = fgetc(in)) != EOF){
			r += (work & 0xFF) << ((1-i)*8);
		}else{
			*out = 0;
			return 0;
		}
	}
	
	*out = r;
	return 1;
}

int read_be_int32(FILE *in, int *out)
{
	int i, work;

	int r = 0;
	
	for(i=0;i<4;i++){
		if((work = fgetc(in)) != EOF){
			r += (work & 0xFF) << ((3-i)*8);
		}else{
			*out = 0;
			return 0;
		}
	}
	
	*out = r;
	return 1;
}

int write_be_int16(short in, FILE *out)
{
	int i;
	
	for(i=0;i<2;i++){
		if((fputc((in >> ((1-i)*8)) & 0xFF, out)) == EOF){
			return 0;
		}
	}

	return 1;
}

int write_be_int32(short in, FILE *out)
{
	int i;
	
	for(i=0;i<4;i++){
		if((fputc((in >> ((3-i)*8)) & 0xFF, out)) == EOF){
			return 0;
		}
	}

	return 1;
}

int le_char_array_to_int32(char *in)
{
	int i;
	int r=0;

	for(i=0;i<4;i++){
		r += ((in[i] & 0xFF) << (i*8));
	}

	return r;
}

short le_char_array_to_int16(char *in)
{
	int i;
	int r=0;

	for(i=0;i<2;i++){
		r += ((in[i] & 0xFF) << (i*8));
	}

	return r;
}

void int32_to_le_char_array(int in, char *out)
{
	int i;

	for(i=0;i<4;i++){
		out[i] = (in >> (i*8)) & 0xFF;
	}
}

void int16_to_le_char_array(int in, char *out)
{
	int i;

	for(i=0;i<4;i++){
		out[i] = (in >> (i*8)) & 0xFF;
	}
}

int be_char_array_to_int32(char *in)
{
	int i;
	int r=0;

	for(i=0;i<4;i++){
		r += ((in[i] & 0xFF) << ((3-i)*8));
	}

	return r;
}

short be_char_array_to_int16(char *in)
{
	int i;
	int r=0;

	for(i=0;i<2;i++){
		r += ((in[i] & 0xFF) << ((1-i)*8));
	}

	return r;
}

void int32_to_be_char_array(int in, char *out)
{
	int i;

	for(i=0;i<4;i++){
		out[i] = (in >> ((3-i)*8)) & 0xFF;
	}
}

void int16_to_be_char_array(int in, char *out)
{
	int i;

	for(i=0;i<4;i++){
		out[i] = (in >> ((1-i)*8)) & 0xFF;
	}
}

int binary_to_4bit_decimal(unsigned char hex)
{
    int r;
    
    if(hex > 99){
        return -1;
    }

    r = hex % 10;
    r += ((hex / 10) << 4);

    return r;
}

/* bit printing routine */

void print_bit(int data, int column, FILE *out)
{
	while(column > 0){
		column -= 1;
		fprintf(out, "%1d", (data >> column) & 1);
	}
}

void file_skip(FILE *stream, size_t skip_size)
{
	char *buffer;

	if(ftell(stream) < 0){
		/* stream is pipe? */
		buffer = (char *)malloc(skip_size);
		fread(buffer, 1, skip_size, stream);
		free(buffer);
	}else{
		fseek(stream, skip_size, SEEK_CUR);
	}
}

size_t get_filesize(char *filepath)
{
	FILE *p;

	size_t r,s;

	p = fopen(filepath, "rb");
	if(p == NULL){
		return 0;
	}

	fseek(p, 0, SEEK_SET);
	s = ftell(p);
	fseek(p, 0, SEEK_END);
	r = ftell(p) - s;
	fseek(p, 0, SEEK_SET);

	fclose(p);

	return r;
}